import time
import random
import subprocess
import tkinter as tk
from tkinter import filedialog, messagebox
import threading

# ===== Default settings =====
START_DELAY = 5
MIN_DELAY = 0.05
MAX_DELAY = 0.15
PUNCTUATION_PAUSE = (0.3, 0.6)
THINKING_PAUSE_CHANCE = 0.03
THINKING_PAUSE = (0.8, 1.5)
# ============================

stop_flag = False  # Global flag to stop typing

# Typing function using AppleScript
def type_char(char):
    safe_char = char.replace('"', '\\"')
    script = f'tell application "System Events" to keystroke "{safe_char}"'
    try:
        subprocess.run(["osascript", "-e", script], check=True)
    except subprocess.CalledProcessError:
        # Show a popup warning once
        if not hasattr(type_char, "warned"):
            type_char.warned = True
            messagebox.showwarning(
                "Permission Error",
                "Failed to type! Make sure 'typer_gui.app' has Accessibility permissions:\n\n"
                "System Settings → Privacy & Security → Accessibility → Add typer_gui.app"
            )

def human_type(text):
    global stop_flag
    for char in text:
        if stop_flag:
            break
        if random.random() < THINKING_PAUSE_CHANCE:
            for _ in range(int(random.uniform(*THINKING_PAUSE)/0.05)):
                if stop_flag:
                    return
                time.sleep(0.05)
        type_char(char)
        if char in ".!?,":
            for _ in range(int(random.uniform(*PUNCTUATION_PAUSE)/0.05)):
                if stop_flag:
                    return
                time.sleep(0.05)
        else:
            for _ in range(int(random.uniform(MIN_DELAY, MAX_DELAY)/0.05)):
                if stop_flag:
                    return
                time.sleep(0.05)

# GUI callbacks
def browse_file():
    file_path = filedialog.askopenfilename(filetypes=[("Text Files", "*.txt")])
    if file_path:
        entry_file.delete(0, tk.END)
        entry_file.insert(0, file_path)

def start_typing_thread():
    threading.Thread(target=start_typing, daemon=True).start()

def start_typing():
    global stop_flag
    stop_flag = False  # Reset stop flag at start
    file_path = entry_file.get()
    if not file_path:
        messagebox.showerror("Error", "Please select a text file first!")
        return
    try:
        with open(file_path, "r", encoding="utf-8") as f:
            text = f.read()
    except Exception as e:
        messagebox.showerror("Error", f"Failed to read file:\n{e}")
        return

    messagebox.showinfo("Get Ready", f"Click your target window. Typing starts in {START_DELAY} seconds.")
    for _ in range(int(START_DELAY / 0.05)):
        if stop_flag:
            return
        time.sleep(0.05)
    human_type(text)
    if not stop_flag:
        messagebox.showinfo("Done", "Finished typing!")

def stop_typing():
    global stop_flag
    stop_flag = True

# GUI setup
root = tk.Tk()
root.title("typer_gui")
root.geometry("450x220")

# File input
tk.Label(root, text="Text File:").pack(pady=(10, 0))
entry_file = tk.Entry(root, width=50)
entry_file.pack(pady=5)
tk.Button(root, text="Browse", command=browse_file).pack(pady=5)

# Start & Stop buttons side by side
button_frame = tk.Frame(root)
button_frame.pack(pady=15)
tk.Button(button_frame, text="Start Typing", command=start_typing_thread, bg="green", fg="white", width=15).grid(row=0, column=0, padx=10)
tk.Button(button_frame, text="Stop Typing", command=stop_typing, bg="red", fg="white", width=15).grid(row=0, column=1, padx=10)

root.mainloop()
